from formatting import *
from decimal import Decimal

class basic_product:

    last_serial_number=0
    
    def __init__(self,name,price):
        self._name=name
        self.price=price
        basic_product.last_serial_number+=1
        self._serial_number=basic_product.last_serial_number

    #Properties
    @property
    @format_as_character
    def name(self):
        return self._name
    
    @property
    @format_as_currency
    def price(self):
        return self._price

    @price.setter
    def price(self,value):
        if value < 0:
            raise ValueError("Negative values not permitted")
        self._price=Decimal(str(value))#Decimal must take a string

    #The representation of our product
    def __repr__(self):
        description = "Product number: " + str(self._serial_number)+"\n"
        description += str(self.name)+" "+ str(self.price)+"\n"
        return description

    def __str__(self):
        return self.name+" "+self.price

    @classmethod
    def _get_last_serial_number(cls):#the cls parameter refers to the class
        return cls.last_serial_number

class product_with_dimensions(basic_product):
    
    def __init__(self,name,price,*dimensions):
        super().__init__(name,price)
        self._dimensions=dimensions


    #The representation of our product
    def __repr__(self):
        description = super().__repr__() \
                      + "Weight (g), height (cm), length(cm), width(cm): " \
                      + str(self._dimensions)+"\n"
        return description

class product_with_keywords(basic_product):
    
    def __init__(self,name,price,*dimensions,**kwargs):
        super().__init__(name,price)
        self._dimensions=dimensions
        self._kwargs=kwargs

    #The representation of our product
    def __repr__(self):
        description = super().__repr__() \
                      + "Weight (g), height (cm), length(cm), width(cm): " \
                      + str(self._dimensions)+"\n"
        for key,value in self._kwargs.items():
            description += key+": "+str(value)+"\n"
        return description

    
